package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.system.param.SysRoleNewParam;
import com.elitescloud.cloudt.system.param.SysRoleQueryParam;
import com.elitescloud.cloudt.system.param.SysRoleUpdateParam;
import com.elitescloud.cloudt.system.provider.param.SysRoleRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.provider.dto.SysRoleRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author Chris
 * @date 2021-08-27
 */
@FeignClient(name = Application.NAME, path = SysRoleRpcService.URI)
@Validated
public interface SysRoleRpcService {
    String URI = Application.URI_PREFIX + "/role";

    /**
     * 获取 应用角色 信息
     *
     * @param param 查询参数
     * @return 应用角色信息
     */
    @PostMapping(value = "/findRoleRpcDtoByParam")
    List<SysRoleRpcDTO> findRoleRpcDtoByParam(@RequestBody SysRoleRpcDtoParam param);

    /**
     * @param param
     * @return
     */
    @PostMapping(value = "/search")
    PagingVO<SysRoleVO> search(@RequestBody SysRoleQueryParam param);

    @PostMapping(value = "/create")
    Long create(@RequestBody SysRoleNewParam role);

    @PostMapping(value = "/update")
    void update(@RequestBody SysRoleUpdateParam reqRole);

    @PostMapping(value = "/listByRoleIds")
    Set<SysRoleVO> listByRoleIds(@RequestBody List<Long> roleIds);

    @GetMapping(value = "/listAll")
    List<SysRoleVO> listAll();

    @GetMapping(value = "/listMenusById")
    List<String> listMenusById(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);

    @GetMapping(value = "/listActionsById")
    List<String> listActionsById(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);

    @GetMapping(value = "/switchRoleStatus")
    Boolean switchRoleStatus(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);
}
