package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRuleGroupDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : chen
 * @description : 角色应用api的数据权限远程调用接口
 * @date : 2022-11-24 14:23
 */
@FeignClient(name = Application.NAME, path = RoleAppApiDataPermissionRpcService.URI)
@Validated
public interface RoleAppApiDataPermissionRpcService {
    String URI = Application.URI_PREFIX + "/role/app/api/data/permission";


    /**
     * 获取角色的数据权限信息
     * @param roelIdList 角色idList
     * @return 角色ID的数据集合
     */
    @GetMapping(value = "/getRoleAppApiDataPermission")
    ApiResult<List<SysDprRoleApiRuleGroupDTO>> getRoleAppApiDataPermission(@NotNull(message = "角色编码不能为空")
                                                     @RequestParam("roelIdList") List<Long> roelIdList);

    List<SysDprRoleApiRuleGroupDTO> searchSysDprRoleApiRuleGroupDTO(List<Long> roelIdList);


    /**
     * 返回账号的角色对应的全部应用-菜单-API-规则组信息和规则信息
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */

    /**
     * 统一身份管理登录后，采用token作为key 存储到redis中登录账号绑定的数据权限信息。
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */

    /**
     * 返回reids中token对应的数据权限数据。 token作为key获取。
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */



}
