package com.elitescloud.cloudt.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <pre>
 *     系统配置表
 * </pre>
 *
 * @author Michael Li
 * @date 2020-06-15
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "系统配置表", description = "系统配置表")
public class SysSettingVO implements Serializable {

    private static final long serialVersionUID = -7840804475330315230L;

    @ApiModelProperty(value = "记录ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "设置的编号", required = true)
    @NotBlank(message = "编号不能为空")
    @Size(min = 3, message = "编号长度不能小于3位")
    private String settingNo;

    @ApiModelProperty(value = "设置名称")
    @NotBlank(message = "名称不能为空")
    private String settingName;

    @ApiModelProperty(value = "设置类型")
    private String settingType;

    @ApiModelProperty(value = "设置类型2")
    private String settingType2;

    @ApiModelProperty(value = "设置类型3")
    private String email;

    @ApiModelProperty(value = "设置状态")
    private String settingStatus;

    @ApiModelProperty(value = "设置描述")
    private String settingDesc;

    @ApiModelProperty(value = "设置值")
    private String settingVal;

    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId = 0L;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime = LocalDateTime.now();

    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId = 0L;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;
}