package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * <pre>
 * 系统用户信息，脱敏
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("系统用户信息，脱敏后")
public class SysUserVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 5583360083063856158L;

    /**
     * 用户账号
     */
    @ApiModelProperty("用户账号")
    private String username;

    /**
     * 用户姓氏
     */
    @ApiModelProperty("用户姓氏")
    private String lastName;

    /**
     * 用户名称
     */
    @ApiModelProperty("用户名称")
    private String firstName;

    /**
     * 性别
     */
    private String gender;

    /**
     * 性别
     */
    private String genderName;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 电子邮箱
     */
    @ApiModelProperty("电子邮箱")
    private String email;

    /**
     * 启用状态
     */
    @ApiModelProperty("用户账号启用状态")
    private Boolean enabled;

    /**
     * 上次登录时间
     */
    @Comment("上次登录时间")
    private LocalDateTime lastLoginTime;

    /**
     * 账号来源
     * {@link UserSourceType}
     */
    private String sourceType;

    /**
     * 账号来源名称
     */
    private String sourceTypeName;

    @ApiModelProperty("角色名称列表")
    @Deprecated
    private String roleNames;

    @ApiModelProperty("角色ids")
    @Deprecated
    private String roleIds;

    @ApiModelProperty("所属租户名称")
    @Deprecated
    private String tenantName;

    @ApiModelProperty("角色集合")
    @Deprecated
    private Set<SysRoleVO> roles;

    @ApiModelProperty("权限集合")
    @Deprecated
    private Set<SysPermissionVO> permissions;
}
