package com.elitescloud.cloudt.constant;

import com.elitescloud.boot.common.BaseUdc;

/**
 * 地区类型.
 *
 * @author Kaiser（wang shao）
 * 2023/1/18
 */
public class AreaType extends BaseUdc<AreaType> {
    private static final long serialVersionUID = 6105019731364802093L;

    public static final AreaType COUNTRY = new AreaType("country", "国家");
    public static final AreaType PROVINCE = new AreaType("province", "省");
    public static final AreaType CITY = new AreaType("city", "市");
    public static final AreaType AREA = new AreaType("area", "县(区)");
    public static final AreaType TOWN = new AreaType("town", "镇(街道)");
    public static final AreaType VILLAGE = new AreaType("village", "村");

    public AreaType() {
    }

    public AreaType(String value) {
        super(value);
    }

    public AreaType(String value, String description) {
        super(value, description);
    }

    @Override
    public String getUdcCode() {
        return "areaType";
    }
}
