package com.elitescloud.cloudt.system.provider.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 消息持久化对象.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@Data
public class SysMqMessageStorageDTO implements Serializable {
    private static final long serialVersionUID = 4824703450021894227L;

    /**
     * 消息标识
     */
    private String messageId;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 渠道编码
     */
    @NotBlank(message = "渠道编码为空")
    private String channel;

    /**
     * 消息内容
     */
    @NotBlank(message = "消息内容为空")
    private String messageContent;

    /**
     * 发送时间
     */
    @NotNull(message = "发送时间为空")
    private LocalDateTime sendTime;

    /**
     * 发送结束时间
     */
    private LocalDateTime finishTime;

    /**
     * 是否本地化消费
     */
    private Boolean local;

    /**
     * 是否发送成功
     */
    private Boolean success;

    /**
     * 发送失败原因
     */
    private String failReason;

    /**
     * 是否可重试发送
     */
    private Boolean retryable;

    /**
     * 原始消息ID
     */
    private String originalMessageId;
}
