package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.msg.custom.AssignParamSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSendParamDTO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author : chen.niu
 * @description : 消息服务消息发送接口
 * @date : 2023/5/25 11:01
 */
@FeignClient(name = Application.NAME, path = SysMsgCustomSendRpcService.URI)
@Validated
public interface SysMsgCustomSendRpcService {
    String URI = Application.URI_PREFIX + "/msg/custom/send";

    /**
     * 自定义消息批量员工参数发送接口
     * EmployeeSendParamDTO 员工发送参数对象
     * @return  批记录ID
     */
    @PostMapping(value = "/customEmployeeSend")
    ApiResult<String> msgCustomEmployeeSend(@RequestBody @Valid EmployeeSendParamDTO param);

    /**
     * 自定义消息批量员工参数发送接口
     * EmployeeSendParamDTO 员工发送参数对象
     * @return  成功失败
     */
    @PostMapping(value = "/customEmployeeSend/batch")
    ApiResult<List<SysSendResultParam>> msgCustomEmployeeSend(@RequestBody @Valid List<EmployeeSendParamDTO> paramList);

    /**
     * 自定义消息批量，传递发送参数接口
     * AssignParamSendParamDTO 自定义消息发送对象
     * @return  批记录ID
     */
    @PostMapping(value = "/customMsgTypeParamSend")
    ApiResult<String> customMsgTypeParamSend(@RequestBody @Valid AssignParamSendParamDTO param);

    /**
     * 自定义消息批量，传递发送参数接口
     * AssignParamSendParamDTO 自定义消息发送对象
     * @return  成功失败
     */
    @PostMapping(value = "/customMsgTypeParamSend/batch")
    ApiResult<List<SysSendResultParam>> customMsgTypeParamSend(@RequestBody @Valid List<AssignParamSendParamDTO> paramList);
}
