package com.elitescloud.cloudt.system.dto.resp;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "SysPlatformMenusDTO", description = "平台菜单DTO")
public class SysPlatformMenusDTO extends BaseModel implements Serializable {
    @ApiModelProperty("菜单归属应用")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    String menusName;

    @ApiModelProperty("菜单类型")
    String menusType;
    @ApiModelProperty("节点类型 菜单,按钮")
    String nodeType;

    @ApiModelProperty("菜单编码")
    String menusCode;

    @ApiModelProperty("排序")
    Integer menusOrder;

    @ApiModelProperty("菜单状态")
    Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;

    @ApiModelProperty("图标")
    String menusIcon;

    @ApiModelProperty("是否展示")
    Boolean display;
    @ApiModelProperty("是否外链接")
    Boolean outerLink;
    @ApiModelProperty("外链接类型")
    String outerLinkType;
}
