/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="cloudt-system", path="/rpc/cloudt/system/userPermission")
@Validated
public interface SysUserPermissionRpcService {
    public static final String URI = "/rpc/cloudt/system/userPermission";

    @GetMapping(value={"/allRoles"})
    public ApiResult<List<IdCodeNameParam>> listAllRoles(@RequestParam(name="tenantCode", required=false) String var1);

    @GetMapping(value={"/allRoles/tenantOrg"})
    public ApiResult<List<IdCodeNameParam>> listAllRolesByTenantOrg(@RequestParam(name="tenantOrgCode", required=false) String var1);

    @PostMapping(value={"/saveUserRoles"})
    public ApiResult<Long> saveUserRoles(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="userId") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @RequestBody List<Long> var2);

    @PostMapping(value={"/saveUserRoles/batch"})
    public ApiResult<List<Long>> saveUserRoles(@RequestBody List<UserRoleSaveDTO> var1);

    @GetMapping(value={"/getUserIdByRoleCode"})
    public ApiResult<Set<Long>> getUserIdByRoleCode(@NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") @RequestParam(value="roleCode") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/listUserByRole"})
    public ApiResult<List<SysUserBasicDTO>> listUserByRole(@NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") @RequestParam(value="roleCode") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") String var1);

    @PostMapping(value={"/authUserByUserId"})
    public ApiResult<OAuthToken> authByUserId(@RequestBody @Valid AuthUserIdQueryDTO var1);
}

