package com.elitescloud.cloudt.constant;

import java.io.Serializable;

/**
 * 登录账号类型.
 *
 * @author Kaiser（wang shao）
 * 2022/7/6
 */
public final class AccountType implements Serializable {
    private static final long serialVersionUID = 2801442526647410143L;

    /**
     * 用户名
     */
    public static final AccountType USERNAME = new AccountType("username");
    /**
     * 手机号
     */
    public static final AccountType MOBILE = new AccountType("mobile");
    /**
     * 邮箱
     */
    public static final AccountType EMAIL = new AccountType("email");

    private final String type;

    public AccountType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AccountType) {
            AccountType accountType = (AccountType) o;
            return accountType.getType() != null && accountType.getType().equals(getType());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }
}
