package com.elitescloud.cloudt.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 系统预警提醒方式.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
public enum SysAlertType {

    /**
     * 短信提醒
     */
    SMS,
    /**
     * 邮件提醒
     */
    EMAIL,
    /**
     * 企业微信
     */
    WX_WORK;

    private static final Map<String, SysAlertType> ALL = Arrays.stream(SysAlertType.values())
            .collect(Collectors.toMap(SysAlertType::name, t -> t, (t1, t2) -> t1));

    public static SysAlertType parse(String v) {
        if (v == null) {
            return null;
        }
        return ALL.get(v);
    }
}
