package com.elitescloud.cloudt.system.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 组织类型.
 *
 * @author Kaiser（wang shao）
 * 2022/10/28
 */
public class OrgType extends BaseUdc<OrgType> {
    private static final long serialVersionUID = 2191438082539700235L;

    public static final OrgType GROUP = new OrgType("group", "集团");
    public static final OrgType AREA = new OrgType("area", "区域");
    public static final OrgType COMPANY = new OrgType("company", "公司");
    public static final OrgType COMPANY_CHILD = new OrgType("company_child", "分公司");
    public static final OrgType DEPT = new OrgType("dept", "部门");

    public OrgType() {
    }

    public OrgType(String value) {
        super(value);
    }

    public OrgType(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public String getUdcCode() {
        return "orgType";
    }
}
