package com.elitescloud.cloudt.system.dto;

import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 第三方接口重试参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/20
 */
@Data
public class ThirdApiRetryParamDTO implements Serializable {
    private static final long serialVersionUID = 2296042463879798961L;

    /**
     * 服务端地址
     * <p>
     * 为空则取当前服务的地址（不包含路由）
     */
    private String serverAddr;

    /**
     * 请求的接口地址
     * <p>
     * 包含路由
     */
    @NotBlank(message = "请求的接口为空")
    private String uri;

    /**
     * 请求方式
     */
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    private Map<String, String[]> reqQueryParams;

    /**
     * 请求体
     */
    private String reqBody;

    /**
     * 请求头
     */
    private Map<String, String[]> reqHeaders;
}
