package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 组织保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/1/2023
 */
@Data
public class OrgUpsertDTO implements Serializable {
    private static final long serialVersionUID = -5782326924224034872L;

    /**
     * 组织ID
     * <p>修改时不可为空</p>
     */
    private Long id;

    /**
     * 组织编码
     */
    @NotBlank(message = "组织编码为空")
    private String code;

    /**
     * 上级组织ID
     */
    private Long parentId;

    /**
     * 组织名称
     */
    @NotBlank(message = "组织名称为空")
    private String name;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 组织类型
     * <p>[UDC]cloudt-system:orgType {@link com.elitescloud.cloudt.system.constant.OrgType}</p>
     */
    private String type;

    /**
     * 是否启用
     * <p>默认是</p>
     */
    private Boolean enabled;

    /**
     * 是否行政组织
     * <p>默认是</p>
     */
    private Boolean executive;

    /**
     * 所属公司ID
     * <p>系统域的公司ID</p>
     */
    private Long ouId;

    /**
     * 区域
     * <p>
     * [UDC]cloudt-system:region {@link com.elitescloud.cloudt.constant.SysRegion}
     */
    private String region;

    /**
     * 事业部
     * <p>
     * [UDC]cloudt-system:businessUnit {@link com.elitescloud.cloudt.constant.SysBusinessUnit}
     */
    private String businessUnit;

    /**
     * 利润中心
     * <p>
     * [UDC]cloudt-system:profitablyCenter {@link com.elitescloud.cloudt.constant.SysProfitablyCenter}
     */
    private String profitablyCenter;

    /**
     * 职能类型
     * <p>
     * [UDC]cloudt-system:functionType {@link com.elitescloud.cloudt.constant.SysFunctionType}
     */
    private String functionType;
}
