package com.elitescloud.cloudt.system.dto.resp;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 组织详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/20
 */
@Data
public class SysOrgDetailRespDTO implements Serializable {
    private static final long serialVersionUID = -7889136531332723870L;

    /**
     * 组织ID
     */
    private Long id;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 上级组织ID
     */
    private Long parentId;

    /**
     * 上级组织名称
     */
    private String parentName;

    /**
     * 是否行政组织
     */
    private Boolean executive;

    /**
     * 组织名称
     */
    private String code;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 组织类型
     */
    private String type;
    private String typeName;

    /**
     * 是否实体组织
     */
    private Boolean entity;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 所属公司名称
     */
    private String ouName;

    /**
     * 区域
     * <p>
     * [UDC]cloudt-system:region {@link com.elitescloud.cloudt.constant.SysRegion}
     */
    private String region;
    private String regionName;

    /**
     * 事业部
     * <p>
     * [UDC]cloudt-system:businessUnit {@link com.elitescloud.cloudt.constant.SysBusinessUnit}
     */
    private String businessUnit;
    private String businessUnitName;

    /**
     * 利润中心
     * <p>
     * [UDC]cloudt-system:profitablyCenter {@link com.elitescloud.cloudt.constant.SysProfitablyCenter}
     */
    private String profitablyCenter;
    private String profitablyCenterName;

    /**
     * 职能类型
     * <p>
     * [UDC]cloudt-system:functionType {@link com.elitescloud.cloudt.constant.SysFunctionType}
     */
    private String functionType;
    private String functionTypeName;

    /**
     * 深度
     */
    private Integer depth;

    /**
     * 指定类型的上级
     */
    private IdCodeNameParam withParent;

    /**
     * 备注
     */
    private String remark;
}
