package com.elitescloud.cloudt.system.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 税率信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/7/2023
 */
@Data
public class SysTaxRateRespDTO implements Serializable {
    private static final long serialVersionUID = -5337617014403645371L;

    /**
     * 税率ID
     */
    private Long id;

    /**
     * 税率编号
     */
    private String taxRateNo;

    /**
     * 税率类型
     */
    private String taxRateType;
    private String taxRateTypeName;

    /**
     * 税率说明
     */
    private String taxRateDesc;

    /**
     * 税率值
     */
    private BigDecimal taxRateValue;

    /**
     * 生效日期
     */
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    private LocalDateTime validTo;

    /**
     * 是否启用
     */
    private Boolean enabled;
}
