package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * UDC RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/25
 */
@FeignClient(name = Application.NAME, path = SysMenuRpcService.URI)
@Validated
public interface SysMenuRpcService {
    String URI = Application.URI_PREFIX + "/Menu";

    /**
     * 获取应用菜单信息
     *
     * @param appCodeList 应用编码
     * @return 菜单信息
     */
    @PostMapping(value = "/getPlatformMenuByAppCodeList")
    ApiResult<List<SysPlatformMenusDTO>> getPlatformMenuByAppCodeList(
            @NotNull(message = "应用编码不能为空") @RequestBody List<String> appCodeList);

    /**
     * 获取租户应用菜单信息
     *
     * @param tenantId 租户编码
     * @param appCodeList 应用编码
     * @return 菜单信息
     */
    @PostMapping(value = "/getTenantMenuByAppCodeList/{tenantId}")
    ApiResult<List<SysPlatformMenusDTO>> getTenantMenuByAppCodeList(
            @PathVariable(name = "tenantId") Long tenantId,
            @NotNull(message = "应用编码不能为空") @RequestBody List<String> appCodeList);

}
