package com.elitescloud.cloudt.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 汇率计算方式.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
public enum CurrencyRateCalcMethod {

    /**
     * 除法
     */
    DIVISION("除法"),
    /**
     * 乘法
     */
    MULTI("乘法"),
    ;

    private final String description;

    CurrencyRateCalcMethod(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, CurrencyRateCalcMethod> ALL = Arrays.stream(CurrencyRateCalcMethod.values())
            .collect(Collectors.toMap(CurrencyRateCalcMethod::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static CurrencyRateCalcMethod parse(String value) {
        return ALL.get(value);
    }
}
