package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheCurrencyRpcService extends CacheableService {

    /**
     * 根据货币编码获取
     *
     * @param currencyCode 货币编码
     * @return 货币信息
     */
    SysCurrencyRespDTO getByCode(@NotBlank String currencyCode);

    /**
     * 获取货币列表
     *
     * @return 货币列表
     */
    List<SysCurrencyRespDTO> currencyList();
}
