package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/19
 */
public interface SysCacheMenuRpcService extends CacheableService {

    /**
     * 获取菜单信息
     *
     * @param menuCode 菜单编码
     * @return
     */
    SysPlatformMenusDTO getMenuInfo(@NotBlank String menuCode);

    /**
     * 获取菜单及其上级菜单
     *
     * @param menuCode
     * @return
     */
    List<IdCodeNameParam> getMenuWithParents(@NotBlank String menuCode);
}
