package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 支付条款.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCachePaymentTermRpcService extends CacheableService {

    /**
     * 根据编码获取
     *
     * @param code 编码获取
     * @return 支付条款
     */
    ComPaymentTermRpcDTO getByCode(@NotBlank String code);

    /**
     * 获取所有支付条款
     *
     * @return 支付条款列表
     */
    List<ComPaymentTermRpcDTO> listAll();
}
