package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheBusinessObjectRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysBusinessObjectRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheBusinessObjectRpcServiceImpl extends AbstractCacheableService implements SysCacheBusinessObjectRpcService {
    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "businessObject";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    @Override
    public List<SysBusinessOperationDTO> allOperation() {
        return super.getAll(() -> getService(SysBusinessObjectRpcService.class).allOperation().computeData());
    }
}
