package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheMenuRpcService;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/19
 */
@Component
public class SysCacheMenuRpcServiceImpl extends AbstractCacheableService implements SysCacheMenuRpcService {

    @Override
    public SysPlatformMenusDTO getMenuInfo(String menuCode) {
        Assert.notBlank(menuCode, "菜单编码为空");

        return super.getOne("code_#_" + menuCode, () -> getRpcService().getMenuInfo(menuCode).computeData());
    }

    @Override
    public List<IdCodeNameParam> getMenuWithParents(String menuCode) {
        Assert.notBlank(menuCode, "菜单编码为空");

        return super.getOne("codeWithParent_#_" + menuCode, () -> getRpcService().getMenuWithParents(menuCode).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "menu";
    }

    private SysMenuRpcService getRpcService() {
        return getService(SysMenuRpcService.class);
    }
}
