package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheSettingRpcServiceImpl extends AbstractCacheableService implements SysCacheSettingRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "setting";
    }

    @Override
    public List<SysSettingVO> all() {
        return super.getAll(() -> getService(SysSettingService.class).all());
    }

    @Override
    public SysSettingVO oneByNo(String no) {
        Assert.hasText(no, "编码为空");
        return super.getOne(no, () -> getService(SysSettingService.class).oneByNo(no));
    }
}
