package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTaxRateRpcService;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheTaxRateRpcServiceImpl extends AbstractCacheableService implements SysCacheTaxRateRpcService {

    @Override
    public SysTaxRateRespDTO getByTxtNo(String no) {
        Assert.hasText(no, "税率编码为空");

        return super.getOne(no, () -> getService(SysTaxRateRpcService.class).getByTaxRateNo(no).computeData());
    }

    @Override
    public List<SysTaxRateRespDTO> getAll() {
        return super.getAll(() -> getService(SysTaxRateRpcService.class).queryList(new SysTaxRateQueryDTO()).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "taxRate";
    }
}
