package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTmplApiRpcService;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTmplApiRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@ConditionalOnClass(SysTmplDTO.class)
public class SysCacheTmplApiRpcServiceImpl extends AbstractCacheableService implements SysCacheTmplApiRpcService {

    @Override
    public SysTmplDTO getByCode(String tmplCode) {
        Assert.hasText(tmplCode, "模板编码为空");

        return super.getOne(tmplCode, () -> getService(SysTmplApiRpcService.class).getByCode(tmplCode).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "tmpl";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }
}
