package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheUdcRpcService;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.SysUdcRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheUdcRpcServiceImpl extends AbstractCacheableService implements SysCacheUdcRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "udc";
    }

    @Override
    public SysUdcDTO getUdc(String appCode, String udcCode) {
        return super.getOne(appCode + "_#_" + udcCode, () -> getRpcService().get(appCode, udcCode).computeData());
    }

    private SysUdcRpcService getRpcService() {
        return getService(SysUdcRpcService.class);
    }
}
