package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheUserRpcServiceImpl extends AbstractCacheableService implements SysCacheUserRpcService {

    @Override
    public SysUserBasicDTO getById(Long id) {
        Assert.notNull(id, "账号ID为空");

        return super.getOne("id_#_" + id, () -> getRpcService().getById(id).computeData());
    }

    @Override
    public SysUserBasicDTO getByUsername(String username) {
        Assert.notBlank(username, "账号为空");

        return super.getOne("username_#_" + username, () -> getRpcService().getByUsername(username).computeData());
    }

    @Override
    public List<SysUserBasicDTO> listAll() {
        return super.getAll(() -> getRpcService().queryUser(new UserQueryDTO()).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "user";
    }

    private UserRpcService getRpcService() {
        return getService(UserRpcService.class);
    }
}
