package com.elitescloud.cloudt.system.constant;


import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 菜单节点类型
 * **/
public enum PlatformMenusNodeEnum {
    MENUS("SYS_PLATFORM", "PlatformMenusNode", "菜单节点类型", "菜单",1),
    MENUS_GROUP("SYS_PLATFORM", "PlatformMenusNode", "菜单节点类型", "菜单组",2),
    BUTTON("SYS_PLATFORM", "PlatformMenusNode", "菜单节点类型", "按钮",3),
    FORM_MENUS("SYS_PLATFORM", "FormMenus", "菜单节点类型", "表单页",4)
            ;

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformMenusNodeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }
    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public String getDescription() {
        return description;
    }

    private static final Map<String, PlatformMenusNodeEnum> ALL = Arrays.stream(PlatformMenusNodeEnum.values())
            .collect(Collectors.toMap(PlatformMenusNodeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析类型
     *
     * @param value 待解析字符串
     * @return
     */
    public static PlatformMenusNodeEnum parse(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
