package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * 用户创建.
 *
 * @author Kaiser（wang shao）
 * 2022/10/27
 */
@Data
public class UserCreateDTO implements Serializable {
    private static final long serialVersionUID = -1507601283916820339L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 登录账号
     */
    @NotBlank(message = "登录账号为空")
    private String username;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 电话
     */
    private String phone;

    /**
     * 个人邮箱
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 地址
     */
    private String address;

    /**
     * 账号来源
     * {@link UserSourceType}
     */
    private String sourceType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 新增的终端
     */
    private Set<String> terminalsAdd;

    /**
     * 所有的终端
     */
    private Set<String> terminalsAll;

    /**
     * 新增的用户类型
     * {@link UserType}
     * @deprecated 请使用 {@link #userTypesAdd}
     */
    @Deprecated
    private Set<String> typesAdd;
    /**
     * 新增的账号类型
     */
    private Set<SysUserTypeDTO> userTypesAdd;

    /**
     * 所有的用户类型
     * {@link UserType}
     * @deprecated 请使用 {@link #userTypesAll}
     */
    @Deprecated
    private Set<String> typesAll;
    /**
     * 新增的账号类型
     */
    private Set<SysUserTypeDTO> userTypesAll;

    /**
     * 扩展参数
     */
    private Object extend;
}
