package com.elitescloud.cloudt.system.dto.req.msg.interior;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description : 消息明细查询
 * @date : 2023/5/25 16:10
 */
@Data
public class SysMsgSendRecordDtlQueryDTO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 4153664465651296499L;
    @ApiModelProperty("消息类型")
    MsgSendTypeEnum msgSendTypeEnum;
    @ApiModelProperty("接收人id")
    Long recipientUserId;
    @ApiModelProperty("接收人名称")
    String recipientUserName;
    @ApiModelProperty("已读未读")
    Boolean readFlag;
    @ApiModelProperty("发送时间开始")
    private LocalDateTime sentTimeStart;
    @ApiModelProperty("发送时间结束")
    private LocalDateTime sentTimeStartEnd;

}
