package com.elitescloud.cloudt.system.dto.req.msg.template;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 模板占位符替换参数对象 ${}是占位符规则
 * @date : 2023/5/25 11:51
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateTxtReplaceDTO implements Serializable {

    private static final long serialVersionUID = -300848680091677986L;

    @ApiModelProperty("发送类型")
    @NotNull(message = "发送类型为空")
    private MsgSendTypeEnum msgSendTypeEnum;

    @ApiModelProperty("占位符键替换map key替换名称，value替换内容 如：${name} key=name，value=名称")
    private Map<String,String> replaceMap;
}
