package com.elitescloud.cloudt.system.dto.resp;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 数据关系查询结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@Getter
@Setter
public class DataRelationRespDTO implements Serializable {
    private static final long serialVersionUID = -6103946580450430034L;
    /**
     * 数据关系编码
     */
    private String drCode;

    /**
     * 分类编码
     */
    private String catCode;

    /**
     * 主数据的标识
     */
    private String dataKey;

    /**
     * 主数据的检索属性
     */
    private String dataAttribute;

    /**
     * 主数据的扩展信息
     */
    private Map<String, String> dataExt;

    /**
     * 关联数据的标识
     */
    private String refDataKey;

    /**
     * 关联数据的检索属性
     */
    private String refDataAttribute;

    /**
     * 关联数据的扩展信息
     */
    private Map<String, String> refDataExt;
}
