package com.elitescloud.cloudt.system.dto.resp;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 员工分页查询返回结果.
 *
 * @author Kaiser（wang shao）
 * @date 2/27/2023
 */
@Data
public class EmployeePageRespDTO implements Serializable {
    private static final long serialVersionUID = -867544757883652835L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 员工编码
     */
    private String code;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 登录号
     */
    private String username;
    private String firstName;
    private String lastName;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * <p>
     * {@link Gender}
     * </p>
     */
    private String gender;

    /**
     * 性别
     */
    private String genderName;

    /**
     * 员工类型
     */
    private String type;

    /**
     * 员工类型
     */
    private String typeName;

    /**
     * 职务
     */
    private String duty;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 下属数量
     */
    private Integer underlingNum;

    /**
     * 组织信息
     */
    private List<IdCodeNameParam> orgList;

    /**
     * 组织名称
     */
    private List<String> orgNames;

    /**
     * 所在组织的指定上级组织
     * <p>
     * 根据 {@link EmployeePageQueryDTO#withParentOrgType} 查询到的上级组织
     */
    private List<IdCodeNameParam> parentOrgList;

    /**
     * 上级领导和组织信息
     */
    private List<EmployeeOrgRespDTO> leadEmployeeOrg;

    /**
     * 是否没有登录账号
     */
    private Boolean withoutLoginAccount;

    /**
     * 获取全名
     *
     * @return 全名
     */
    public String getFullName() {
        if (StringUtils.hasText(fullName)) {
            return fullName;
        }
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }

    /**
     * 获取性别
     *
     * @return 性别
     */
    public String getGenderName() {
        if (CharSequenceUtil.isBlank(getGender())) {
            return null;
        }
        return new Gender(getGender()).getDescription();
    }

    /**
     * 是否有下级员工
     *
     * @return 是否有下级员工
     */
    public Boolean getHasUnderling() {
        return underlingNum != null && underlingNum > 0;
    }
}
