package com.elitescloud.cloudt.system.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * 2020/7/8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@ApiModel("系统用户查询条件")
public class SysUserQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 724644499628241282L;

    @ApiModelProperty("用户账号")
    String username;

    @ApiModelProperty("用户姓名")
    String name;

    @ApiModelProperty("手机号")
    String mobile;

    @ApiModelProperty("电子邮箱")
    String email;

    @ApiModelProperty("所属租户名称")
    String tenantName;

    @ApiModelProperty("账号是否启用")
    Boolean enabled;

    @ApiModelProperty("角色ID列表")
    List<Long> roleIds;

    @ApiModelProperty("数据来源")
    String sourceType;

    @ApiModelProperty(value = "是否同步 0 未同步 1 已同步")
    Integer transFlag;
}
