package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 菜单 RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/25
 */
@FeignClient(name = Application.NAME, path = SysMenuRpcService.URI)
@Validated
@DocumentedFeignApi(description = "菜单服务接口")
public interface SysMenuRpcService {
    String URI = Application.URI_PREFIX + "/Menu";

    /**
     * 新增菜单
     *
     * @param saveDTO
     * @return
     */
    @PostMapping(value = "/add")
    @DocumentedFeignApi(description = "菜单添加接口")
    ApiResult<Long> addMenu(@RequestBody SysMenuSaveDTO saveDTO);

    /**
     * 删除菜单
     *
     * @param menuCode
     * @return
     */
    @PostMapping(value = "/delete")
    @DocumentedFeignApi(description = "菜单添加删除")
    ApiResult<String> removeMenu(@NotBlank(message = "菜单编码为空") @RequestParam(name = "menuCode") String menuCode);

    /**
     * 获取应用菜单信息
     *
     * @param appCodeList 应用编码
     * @return 菜单信息
     */
    @DocumentedFeignApi(description = "获取应用菜单信息")
    @PostMapping(value = "/getPlatformMenuByAppCodeList")
    ApiResult<List<SysPlatformMenusDTO>> getPlatformMenuByAppCodeList(
            @NotNull(message = "应用编码不能为空") @RequestBody List<String> appCodeList);

    /**
     * 获取租户应用菜单信息
     *
     * @param tenantId    租户编码
     * @param appCodeList 应用编码
     * @return 菜单信息
     */
    @DocumentedFeignApi(description = "获取租户应用菜单信息")
    @PostMapping(value = "/getTenantMenuByAppCodeList/{tenantId}")
    ApiResult<List<SysPlatformMenusDTO>> getTenantMenuByAppCodeList(
            @PathVariable(name = "tenantId") Long tenantId,
            @NotNull(message = "应用编码不能为空") @RequestBody List<String> appCodeList);

    /**
     * 获取菜单信息
     *
     * @param menuCode 菜单编码
     * @return
     */
    @DocumentedFeignApi(description = "根据菜单编码获取菜单信息")
    @GetMapping(value = "/get")
    ApiResult<SysPlatformMenusDTO> getMenuInfo(@NotBlank(message = "菜单编码为空") @RequestParam(name = "menuCode") String menuCode);

    /**
     * 获取菜单信息
     *
     * @param menuCodes 菜单编码
     * @return
     */
    @DocumentedFeignApi(description = "根据菜单编码获取菜单信息列表")
    @PostMapping(value = "/getList")
    ApiResult<List<SysPlatformMenusDTO>> getMenuInfo(@RequestBody Set<String> menuCodes);

    /**
     * 获取菜单及其上级菜单
     *
     * @param menuCode
     * @return
     */
    @DocumentedFeignApi(description = "获取菜单及其上级菜单")
    @GetMapping(value = "/getWithParents")
    ApiResult<List<IdCodeNameParam>> getMenuWithParents(@NotBlank(message = "菜单编码为空") @RequestParam(name = "menuCode") String menuCode);
}
