package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发号器.
 *
 * @author Kaiser（wang shao）
 * 2022/11/15
 */
@FeignClient(name = Application.NAME, path = SysSeqNumRpcService.URI)
@Validated
@DocumentedFeignApi( description = "发号器")
public interface SysSeqNumRpcService {
    String URI = Application.URI_PREFIX + "/seqNum";

    /**
     * 生成示例代码
     *
     * @param appCode       应用编码
     * @param ruleCode      发号规则
     * @param runtimeValues 运行时参数
     * @return 下一序号
     */
    @PostMapping(value = "/generate/sampleCode/byCode")
    @DocumentedFeignApi( description = "生成示例编码-编码  用于测试生成效果")
    ApiResult<String> generateSampleCode(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                         @NotBlank(message = "发号规则编码为空") @RequestParam(name = "ruleCode") String ruleCode,
                                         @RequestBody List<String> runtimeValues);

    /**
     * 生成示例代码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 运行时参数
     * @return 下一序号
     */
    @PostMapping(value = "/generate/sampleCode")
    @DocumentedFeignApi( description = "生成示例编码-ID，用于测试生成效果")
    ApiResult<String> generateSampleCode(@NotBlank(message = "发号规则ID为空") @RequestParam(name = "ruleId") Long ruleId,
                                         @RequestBody List<String> runtimeValues);

    /**
     * 生成下一代码
     *
     * @param appCode       应用编码
     * @param ruleCode      发号规则
     * @param runtimeValues 运行时参数
     * @return 下一序号
     */
    @PostMapping(value = "/generate/code/byCode")
    @DocumentedFeignApi( description = "生成下一编码")
    ApiResult<String> generateCode(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                   @NotBlank(message = "发号规则编码为空") @RequestParam(name = "ruleCode") String ruleCode,
                                   @RequestBody List<String> runtimeValues);

    /**
     * 生成下一代码
     *
     * @param appCode       应用编码
     * @param ruleCode      发号规则
     * @param runtimeValues 运行时参数
     * @param num           发号数量
     * @return 下一序号
     */
    @PostMapping(value = "/generate/code/byCode/batch")
    @DocumentedFeignApi( description = "批量生成下一编码")
    ApiResult<List<String>> generateCode(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                         @NotBlank(message = "发号规则编码为空") @RequestParam(name = "ruleCode") String ruleCode,
                                         @RequestBody List<String> runtimeValues,
                                         @NotNull(message = "发号数量不能为空") @RequestParam(name = "num", defaultValue = "1") Integer num);

    /**
     * 生成下一代码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 运行时参数
     * @return 下一序号
     */
    @PostMapping(value = "/generate/code")
    @DocumentedFeignApi( description = "生成下一序号")
    ApiResult<String> generateCode(@NotNull(message = "发号规则ID为空") @RequestParam(name = "ruleId") Long ruleId,
                                   @RequestBody List<String> runtimeValues);

    /**
     * 生成下一代码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 运行时参数
     * @param num           发号数量
     * @return 下一序号
     */
    @PostMapping(value = "/generate/code/batch")
    ApiResult<List<String>> generateCode(@NotNull(message = "发号规则ID为空") @RequestParam(name = "ruleId") Long ruleId,
                                         @RequestBody List<String> runtimeValues,
                                         @NotNull(message = "发号数量不能为空") @RequestParam(name = "num", defaultValue = "1") Integer num);

    /**
     * 生成下一序号
     *
     * @param nextNumberId 下一序号ID
     * @param len          下一序号的最大宽度
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber")
    @DocumentedFeignApi( description = "生成下一序号 ID生成")
    ApiResult<Long> generateNextNumber(@NotNull(message = "下一序号ID为空") @RequestParam(name = "nextNumberId") Long nextNumberId,
                                       @RequestParam(name = "len", required = false) Integer len);

    /**
     * 生成下一序号
     *
     * @param nextNumberId 下一序号ID
     * @param len          下一序号的最大宽度
     * @param num          下一序号数量
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber/batch")
    @DocumentedFeignApi( description = "批量生成下一序号 ID生成")
    ApiResult<List<Long>> generateNextNumber(@NotNull(message = "下一序号ID为空") @RequestParam(name = "nextNumberId") Long nextNumberId,
                                             @RequestParam(name = "len", required = false) Integer len,
                                             @NotNull(message = "下一序号数量不能为空") @RequestParam(name = "num", defaultValue = "1") Integer num);


    /**
     * 生成下一序号
     *
     * @param appCode        应用编码
     * @param nextNumberCode 下一序号的编码
     * @param len            下一序号的最大宽度
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber/byCode")
    @DocumentedFeignApi( description = "生成下一序号 code生成")
    ApiResult<Long> generateNextNumber(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                       @NotBlank(message = "下一序号的编码为空") @RequestParam(name = "nextNumberCode") String nextNumberCode,
                                       @RequestParam(name = "len", required = false) Integer len);

    /**
     * 生成下一序号
     *
     * @param appCode        应用编码
     * @param nextNumberCode 下一序号的编码
     * @param len            下一序号的最大宽度
     * @param num            下一序号数量
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber/byCode/batch")
    @DocumentedFeignApi( description = "批量生成下一序号 code生成")
    ApiResult<List<Long>> generateNextNumber(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                             @NotBlank(message = "下一序号的编码为空") @RequestParam(name = "nextNumberCode") String nextNumberCode,
                                             @RequestParam(name = "len", required = false) Integer len,
                                             @NotNull(message = "下一序号数量不能为空") @RequestParam(name = "num", defaultValue = "1") Integer num);
}
