package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * UDC RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/25
 */
@FeignClient(name = Application.NAME, path = SysUdcRpcService.URI)
@Validated
@DocumentedFeignApi( description = "UDC服务")
public interface SysUdcRpcService {
    String URI = Application.URI_PREFIX + "/udc";

    /**
     * 获取UDC信息
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */
    @GetMapping(value = "/get")
    @DocumentedFeignApi( description = "UDC查询，编码一条")
    ApiResult<SysUdcDTO> get(@NotBlank(message = "应用编码不能为空") @RequestParam(name = "appCode") String appCode,
                             @NotBlank(message = "UDC编码不能为空") @RequestParam(name = "udcCode") String udcCode);

    /**
     * 获取UDC信息
     *
     * @param appCode  应用编码
     * @param udcCodes UDC编码列表
     * @return UDC信息列表
     */
    @PostMapping(value = "/listByUdcCode")
    @DocumentedFeignApi( description = "UDC批量查询")
    ApiResult<List<SysUdcDTO>> listByUdcCode(@NotBlank(message = "应用编码不能为空") @RequestParam(name = "appCode") String appCode,
                                             @RequestBody Set<String> udcCodes);
}
