package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.msg.interior.InteriorReadUpdateDTO;
import com.elitescloud.cloudt.system.dto.req.msg.interior.SysMsgSendRecordDtlQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSendRecordDtlDTO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * @author : chen.niu
 * @description : 站内消息
 * @date : 2023/5/25 15:58
 */
@FeignClient(name = Application.NAME, path = SysMsgInteriorRpcService.URI)
@Validated
@DocumentedFeignApi( description = "站内消息服务")
public interface SysMsgInteriorRpcService {
    String URI = Application.URI_PREFIX + "/msg/interior";

    /**
     * 模板消息批量，员工参数发送接口（RPC接口
     *
     * @return 角色ID的数据集合
     */
    @PostMapping(value = "/sysMsgSendRecordDtlInteriorQuery")
    @DocumentedFeignApi( description = "模板消息批量，员工参数发送接口")
    ApiResult<PagingVO<SysMsgSendRecordDtlDTO>> sysMsgSendRecordDtlInteriorQuery(@RequestBody @Valid SysMsgSendRecordDtlQueryDTO dto);

    /**
     * 站内消息已读修改
     *
     * @return 消息明细站内对象
     */
    @PostMapping(value = "/sysMsgSendRecordDtlInteriorReadUpdate")
    @DocumentedFeignApi( description = "消息明细站内对象")
    ApiResult<Boolean> sysMsgSendRecordDtlInteriorReadUpdate(@RequestBody @Valid InteriorReadUpdateDTO dto);

    /**
     * 查询发送结果
     *
     * @param recordIds 发送记录标识
     * @return 结果
     */
    @PostMapping(value = "/querySentResult")
    @DocumentedFeignApi( description = "查询发送结果")
    ApiResult<List<SysMsgSentResultDTO>> querySentResult(@RequestBody Set<String> recordIds);

    /**
     * 获取消息的阅读结果
     *
     * @param recordId 发送记录标识
     * @return 阅读结果
     */
    @GetMapping(value = "/getViewedResult")
    @DocumentedFeignApi( description = "获取消息的阅读结果")
    ApiResult<List<SysMsgViewResultDTO>> getViewedResult(@NotBlank(message = "记录ID为空") @RequestParam("recordId") String recordId);
}
