package com.elitescloud.cloudt.system.datasource;


import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;


public enum DataSourceTypeEnum {
    MYSQL("SYS_PLATFORM", "DataSourceType", "数据库类型", "MYSQL", 1),
    ORACLE("SYS_PLATFORM", "DataSourceType", "数据库类型", "ORACLE", 2),
    SQLSERVER("SYS_PLATFORM", "DataSourceType", "数据库类型", "SQLSERVER", 3),
    POSTGRESQL("SYS_PLATFORM", "DataSourceType", "数据库类型", "POSTGRESQL", 4)
    ;
    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    DataSourceTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }

    private static final Map<String, DataSourceTypeEnum> ALL = Arrays.stream(DataSourceTypeEnum.values())
            .collect(Collectors.toMap(DataSourceTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析类型
     *
     * @param value 待解析字符串
     * @return
     */
    public static DataSourceTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
