package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import lombok.Data;

import java.util.Set;

/**
 * 分页查询组织.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/13
 */
@Data
public class SysOrgPageQueryDTO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 6577525121974223412L;

    /**
     * 组织ID
     */
    private Set<Long> ids;

    /**
     * 组织编码
     */
    private Set<String> codes;

    /**
     * 外部组织编码
     */
    private Set<String> outerCodes;

    /**
     * 上级组织ID
     */
    private Long parentId;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 是否行政组织
     */
    private Boolean executive;

    /**
     * 组织编码
     */
    private String code;

    /**
     * 外部组织编码
     */
    private String outerCode;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 组织类型
     * <p></p>
     * {@link com.elitescloud.cloudt.system.constant.OrgType}
     */
    private String type;

    /**
     * 是否实体
     */
    private Boolean entity;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 所属公司ID（系统域的）
     */
    private Long ouId;

    /**
     * 所属组织的ID
     * <p>
     * 该组织下的所有子孙组织（包含自己）
     */
    private Long orgIdBelong;

    /**
     * 所属组织的ID
     * <p>
     * 该组织下的所有子孙组织（包含自己）
     */
    private String orgCodeBelong;

    /**
     * 返回的上级类型（包含自己）
     * <p>
     * 需要同时返回符合组织类型（{@link com.elitescloud.cloudt.system.constant.OrgType}）的上级组织，
     * 如返回组织的所属公司，则是返回其上级（包含自己）中是公司类型的组织
     */
    private String withParentType;

    /**
     * 外部组织编码不为空的
     */
    private Boolean ownOuterCode;
}
