package com.elitescloud.cloudt.system.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 行政区域信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@Data
public class SysAreaRespDTO implements Serializable {
    private static final long serialVersionUID = 2572110451314737082L;

    /**
     * ID
     */
    private Long id;

    /**
     * 地区名称
     */
    private String areaName;

    /**
     * 行政区域编码
     */
    private String areaCode;

    /**
     * 上级行政区域编码
     */
    private String parentAreaCode;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 区域类型
     * <p>UDC[cloudt-system:areaType] {@link com.elitescloud.cloudt.constant.AreaType}</p>
     */
    private String areaType;

    /**
     * 邮编
     */
    private String zipCode;

    /**
     * 启用状态
     */
    private Boolean enabled;

    /**
     * 名称拼音
     */
    private String pinyin;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 下级
     */
    private List<SysAreaRespDTO> children;
}
