package com.elitescloud.cloudt.system.provider.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * MQ消息发送结果.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/28
 */
@Data
public class SysMqSendResultDTO implements Serializable {
    private static final long serialVersionUID = 7858509735215000310L;

    /**
     * 消息ID
     */
    @NotBlank(message = "消息ID为空")
    private String messageId;

    /**
     * 发送结果
     */
    @NotNull(message = "发送结果为空")
    private Boolean success;

    /**
     * 失败原因
     */
    private String failReason;
}
