package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeGroupRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeGroupRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.org, name = "员工组")
public class SysCacheEmployeeGroupRpcServiceImpl extends AbstractCacheableService implements SysCacheEmployeeGroupRpcService {

    @CloudtCacheMethod(name = "根据编码获取员工组信息")
    @Override
    public SysEmpGroupDTO getByCode(String groupCode) {
        Assert.hasText(groupCode, "员工组编码为空");

        return getService(EmployeeGroupRpcService.class).getByCode(groupCode).computeData();
    }

    @CloudtCacheMethod(name = "根据ID获取员工组信息")
    @Override
    public SysEmpGroupDTO getById(Long groupId) {
        Assert.notNull(groupId, "员工组ID为空");

        return getService(EmployeeGroupRpcService.class).getById(groupId).computeData();
    }

    @CloudtCacheMethod(name = "获取员工组列表")
    @Override
    public List<SysEmpGroupDTO> listAll() {
        return getService(EmployeeGroupRpcService.class).listAll().computeData();
    }

    @CloudtCacheMethod(name = "根据员工组编码获取员工组下的员工账号ID")
    @Override
    public List<Long> listUserIdByGroupCode(String groupCode) {
        Assert.hasText(groupCode, "员工组编码为空");

        return getService(EmployeeGroupRpcService.class).getUserIdsByGroupCode(groupCode).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "employeeGroup";
    }
}
