/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.datadiff;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.datadiff.annotation.AuditField;
import com.elitescloud.cloudt.datadiff.annotation.AuditIgnoreField;
import com.elitescloud.cloudt.datadiff.annotation.AuditObject;
import com.elitescloud.cloudt.datadiff.context.AuditLogContext;
import com.elitescloud.cloudt.datadiff.vo.AuditDiffVO;
import com.elitescloud.cloudt.datadiff.vo.AuditFieldVO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFunctionObjectDiff {
    private static final Logger log = LoggerFactory.getLogger(CustomFunctionObjectDiff.class);
    public static final String DEFAULT_DIFF_MSG_FORMAT = "\u3010${_fieldName}\u3011\u4ece\u3010${_oldValue}\u3011\u53d8\u6210\u4e86\u3010${_newValue}\u3011";
    public static final String DEFAULT_DIFF_MSG_SEPARATOR = " ";
    public static final String DEFAULT_DIFF_NULL_TEXT = " ";
    private static String DIFF_MSG_FORMAT;
    private static String DIFF_MSG_SEPARATOR;

    public CustomFunctionObjectDiff() {
        DIFF_MSG_FORMAT = DEFAULT_DIFF_MSG_FORMAT;
        DIFF_MSG_SEPARATOR = " ";
        log.info("[PHOENIX-AUDIT] CustomFunctionObjectDiff init diffMsgFormat [{}] diffMsgSeparator [{}]", (Object)DIFF_MSG_FORMAT, (Object)DIFF_MSG_SEPARATOR);
    }

    public static AuditDiffVO objectDiff(Object oldObject, Object newObject) {
        Field[] fields;
        StringBuilder msg = new StringBuilder();
        if (oldObject == null || newObject == null) {
            log.warn("[PHOENIX-AUDIT] null object found [{}] [{}]", oldObject, newObject);
            return null;
        }
        String oldClassName = oldObject.getClass().getName();
        String newClassName = newObject.getClass().getName();
        AuditObject oldObjectLogRecordDiff = oldObject.getClass().getDeclaredAnnotation(AuditObject.class);
        AuditObject newObjectLogRecordDiff = newObject.getClass().getDeclaredAnnotation(AuditObject.class);
        boolean oldClassEnableAllFields = oldObjectLogRecordDiff != null && oldObjectLogRecordDiff.enableAllFields();
        boolean newClassEnableAllFields = newObjectLogRecordDiff != null && newObjectLogRecordDiff.enableAllFields();
        log.debug("[PHOENIX-AUDIT] OldClassEnableAllFields [{}] newClassEnableAllFields [{}]", (Object)oldClassEnableAllFields, (Object)newClassEnableAllFields);
        String oldClassAlias = oldObjectLogRecordDiff != null && StringUtils.isNotBlank((CharSequence)oldObjectLogRecordDiff.alias()) ? oldObjectLogRecordDiff.alias() : null;
        String newClassAlias = newObjectLogRecordDiff != null && StringUtils.isNotBlank((CharSequence)newObjectLogRecordDiff.alias()) ? newObjectLogRecordDiff.alias() : null;
        log.debug("[PHOENIX-AUDIT] OldClassName [{}] oldClassAlias [{}] newClassName [{}] newClassAlias [{}]", new Object[]{oldClassName, oldClassAlias, newClassName, newClassAlias});
        LinkedHashMap<String, String> oldFieldAliasMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> newFieldAliasMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Object> oldValueMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> newValueMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> oldFieldZhNameMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> newFieldZhNameMap = new LinkedHashMap<String, String>();
        for (Field oldField : fields = oldObject.getClass().getDeclaredFields()) {
            try {
                AuditField oldFieldAuditField = oldField.getDeclaredAnnotation(AuditField.class);
                AuditIgnoreField oldFieldLogRecordIgnoreField = oldField.getDeclaredAnnotation(AuditIgnoreField.class);
                if (!CustomFunctionObjectDiff.judgeFieldDiffNeeded(oldClassEnableAllFields, oldFieldAuditField, oldFieldLogRecordIgnoreField)) {
                    log.debug("[PHOENIX-AUDIT] OldField [{}] not need to diff, skip", (Object)oldField.getName());
                    continue;
                }
                try {
                    Field newField = newObject.getClass().getDeclaredField(oldField.getName());
                    AuditField newFieldAuditField = newField.getDeclaredAnnotation(AuditField.class);
                    AuditIgnoreField newFieldAuditIgnoreField = newField.getDeclaredAnnotation(AuditIgnoreField.class);
                    if (!CustomFunctionObjectDiff.judgeFieldDiffNeeded(newClassEnableAllFields, newFieldAuditField, newFieldAuditIgnoreField)) {
                        log.debug("[PHOENIX-AUDIT] NewField [{}] not need to diff, skip", (Object)newField.getName());
                        continue;
                    }
                    if (oldFieldAuditField != null && newFieldAuditField != null) {
                        String oldFieldAlias = StringUtils.isNotBlank((CharSequence)oldFieldAuditField.alias()) ? oldFieldAuditField.alias() : null;
                        String newFieldAlias = StringUtils.isNotBlank((CharSequence)newFieldAuditField.alias()) ? newFieldAuditField.alias() : null;
                        String oldFieldZhName = StringUtils.isNotBlank((CharSequence)oldFieldAuditField.fieldZhName()) ? oldFieldAuditField.fieldZhName() : null;
                        String newFieldZhName = StringUtils.isNotBlank((CharSequence)newFieldAuditField.fieldZhName()) ? newFieldAuditField.fieldZhName() : null;
                        oldFieldAliasMap.put(oldField.getName(), oldFieldAlias);
                        newFieldAliasMap.put(newField.getName(), newFieldAlias);
                        oldFieldZhNameMap.put(oldField.getName(), oldFieldZhName);
                        newFieldZhNameMap.put(newField.getName(), newFieldZhName);
                        log.debug("[PHOENIX-AUDIT] Field [{}] has annotation oldField alias [{}] newField alias [{}]", new Object[]{oldField.getName(), oldFieldAlias, newFieldAlias});
                    }
                    oldField.setAccessible(true);
                    newField.setAccessible(true);
                    Object oldValue = oldField.get(oldObject);
                    Object newValue = newField.get(newObject);
                    if (CustomFunctionObjectDiff.fieldValueEquals(oldValue, newValue)) continue;
                    log.debug("[PHOENIX-AUDIT] Field [{}] is different between oldObject [{}] newObject [{}]", new Object[]{oldField.getName(), oldValue, newValue});
                    oldValueMap.put(oldField.getName(), oldValue);
                    newValueMap.put(newField.getName(), newValue);
                }
                catch (NoSuchFieldException e) {
                    log.info("[PHOENIX-AUDIT] No field named [{}] in newObject, skip", (Object)oldField.getName());
                }
            }
            catch (Exception e) {
                log.error("[PHOENIX-AUDIT] ObjectDiff error", (Throwable)e);
            }
        }
        ArrayList<String> diffMsgList = new ArrayList<String>();
        log.debug("[PHOENIX-AUDIT] OldFieldAliasMap [{}]", oldFieldAliasMap);
        log.debug("[PHOENIX-AUDIT] NewFieldAliasMap [{}]", newFieldAliasMap);
        log.debug("[PHOENIX-AUDIT] OldValueMap [{}]", oldValueMap);
        log.debug("[PHOENIX-AUDIT] NewValueMap [{}]", newValueMap);
        AuditDiffVO auditDiffVO = new AuditDiffVO();
        auditDiffVO.setOldClassName(oldClassName);
        auditDiffVO.setOldClassAlias(oldClassAlias);
        auditDiffVO.setNewClassName(newClassName);
        auditDiffVO.setNewClassAlias(newClassAlias);
        ArrayList<AuditFieldVO> auditFieldVOList = new ArrayList<AuditFieldVO>();
        auditDiffVO.setAuditFieldVOList(auditFieldVOList);
        for (Map.Entry entry : oldValueMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            Object oldValue = entry.getValue();
            Object newValue = newValueMap.getOrDefault(entry.getKey(), null);
            String oldFieldAlias = oldFieldAliasMap.getOrDefault(entry.getKey(), null);
            String newFieldAlias = newFieldAliasMap.getOrDefault(entry.getKey(), null);
            String oldFieldZhName = oldFieldZhNameMap.getOrDefault(entry.getKey(), null);
            String newFieldZhName = newFieldZhNameMap.getOrDefault(entry.getKey(), null);
            AuditFieldVO auditFieldVO = new AuditFieldVO();
            auditFieldVO.setFieldName(fieldName);
            auditFieldVO.setOldFieldAlias(oldFieldAlias);
            auditFieldVO.setNewFieldAlias(newFieldAlias);
            auditFieldVO.setOldFieldZhName(oldFieldZhName);
            auditFieldVO.setNewFieldZhName(newFieldZhName);
            auditFieldVO.setOldValue(oldValue);
            auditFieldVO.setNewValue(newValue);
            auditFieldVOList.add(auditFieldVO);
            HashMap<String, String> valuesMap = new HashMap<String, String>(3);
            valuesMap.put("_fieldName", StringUtils.isNotBlank((CharSequence)oldFieldAlias) ? oldFieldAlias : fieldName);
            valuesMap.put("_oldValue", oldValue == null ? " " : oldValue.toString());
            valuesMap.put("_newValue", newValue == null ? " " : newValue.toString());
            diffMsgList.add(String.format(DEFAULT_DIFF_MSG_FORMAT, valuesMap));
        }
        msg.append(String.join((CharSequence)" ", diffMsgList));
        AuditLogContext.addDiff(auditDiffVO);
        return auditDiffVO;
    }

    private static boolean judgeFieldDiffNeeded(boolean classEnableAllFields, AuditField fieldAuditField, AuditIgnoreField fieldLogRecordIgnoreField) {
        return classEnableAllFields && fieldLogRecordIgnoreField == null || fieldAuditField != null && fieldLogRecordIgnoreField == null;
    }

    private static boolean fieldValueEquals(Object oldValue, Object newValue) {
        try {
            boolean isAllNotPrimitive;
            if (oldValue == null && newValue == null) {
                return true;
            }
            if (oldValue == null || newValue == null) {
                return false;
            }
            boolean isAllPrimitive = CustomFunctionObjectDiff.isWrapClassOrPrimitive(oldValue.getClass()) && CustomFunctionObjectDiff.isWrapClassOrPrimitive(newValue.getClass());
            boolean bl = isAllNotPrimitive = !CustomFunctionObjectDiff.isWrapClassOrPrimitive(oldValue.getClass()) && !CustomFunctionObjectDiff.isWrapClassOrPrimitive(newValue.getClass());
            if (isAllPrimitive) {
                return oldValue.equals(newValue);
            }
            if (isAllNotPrimitive) {
                if (CustomFunctionObjectDiff.isJsonArray(oldValue) && CustomFunctionObjectDiff.isJsonArray(newValue)) {
                    JSONArray oldJsonArray = JSONUtil.parseArray((Object)oldValue);
                    JSONArray newJsonArray = JSONUtil.parseArray((Object)newValue);
                    return oldJsonArray.equals((Object)newJsonArray);
                }
                if (!CustomFunctionObjectDiff.isJsonArray(oldValue.getClass()) && !CustomFunctionObjectDiff.isJsonArray(newValue.getClass())) {
                    try {
                        JSONObject oldJsonObject = JSONUtil.parseObj((Object)oldValue);
                        JSONObject newJsonObject = JSONUtil.parseObj((Object)newValue);
                        return oldJsonObject.equals((Object)newJsonObject);
                    }
                    catch (ClassCastException e) {
                        return oldValue.equals(newValue);
                    }
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isWrapClassOrPrimitive(Class clz) {
        return clz.isPrimitive() || clz == Integer.class || clz == Long.class || clz == Short.class || clz == Boolean.class || clz == Byte.class || clz == Float.class || clz == Double.class || clz == String.class;
    }

    private static boolean isJsonArray(Object obj) {
        return obj.getClass().isArray() || obj instanceof Collection;
    }
}

