package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTmplApiRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTmplApiRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@ConditionalOnClass(SysTmplDTO.class)
@CloudtCache(type = SysCacheType.basic, name = "导入导出模板")
public class SysCacheTmplApiRpcServiceImpl extends AbstractCacheableService implements SysCacheTmplApiRpcService {

    @CloudtCacheMethod(name = "根据编码获取模板信息")
    @Override
    public SysTmplDTO getByCode(String tmplCode) {
        Assert.hasText(tmplCode, "模板编码为空");

        return getService(SysTmplApiRpcService.class).getByCode(tmplCode).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "tmpl";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }
}
