package com.elitescloud.cloudt.system.provider.param;

import com.elitescloud.cloudt.common.constant.Terminal;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * @author Chris
 * 2021-08-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserRpcSaveParam implements Serializable {

    private static final long serialVersionUID = -7365895835936127854L;

    /**
     * 用户账号名称
     */
    @NotBlank(message = "用户名不能为空")
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 用户姓氏
     */
    private String lastName;

    /**
     * 用户名称
     */
    private String firstName;

    /**
     * 用户手机号码
     */
    @NotBlank(message = "手机号不能为空")
    private String mobile;

    /**
     * 用户邮箱地址
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 用户所属公司ID
     */
    private Long ouId;

    /**
     * 用户所属公司编号
     */
    @ApiModelProperty("用户所属公司编号")
    private String ouCode;

    /**
     * 用户所属公司名称
     */
    @ApiModelProperty("用户所属公司名称")
    private String ouName;

    /**
     * 功能角色ID列表
     */
    private List<Long> roleIds;

    /**
     * 数据角色ID列表
     */
    private List<Long> dataRoleIds;

    /**
     * 流程角色ID列表
     */
    private List<Long> flowRoleIds;

    /**
     * 账号来源, sys： 系统创建；wec：微信创建；oth：其他方式
     */
    private String sourceType;

    /**
     * 用户终端
     * 可登录的端
     */
    private Set<Terminal> terminals;

    /**
     * 租户ID
     */
    private Long tenantId;
}
