package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 组织.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheOrgRpcService extends CacheableService {

    /**
     * 根据组织编码获取组织信息
     *
     * @param orgId
     * @return
     */
    SysOrgBasicDTO get(@NotBlank Long orgId);

    /**
     * 根据组织编码获取组织信息
     *
     * @param orgCode
     * @return
     */
    SysOrgBasicDTO getByCode(@NotBlank String orgCode);

    /**
     * 获取所有组织
     *
     * @return
     */
    List<SysOrgBasicDTO> listAll();
}
