package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheCurrencyRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "货币")
public class SysCacheCurrencyRpcServiceImpl extends AbstractCacheableService implements SysCacheCurrencyRpcService {

    @CloudtCacheMethod(name = "根据编码获取货币信息")
    @Override
    public SysCurrencyRespDTO getByCode(String currencyCode) {
        Assert.hasText(currencyCode, "货币编码为空");
        return getService(SysCurrencyRpcService.class).getByCode(currencyCode).computeData();
    }

    @CloudtCacheMethod(name = "获取货币列表")
    @Override
    public List<SysCurrencyRespDTO> currencyList() {
        return getService(SysCurrencyRpcService.class).queryList(new SysCurrencyQueryDTO()).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "currency";
    }
}
