package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "系统设置")
public class SysCacheSettingRpcServiceImpl extends AbstractCacheableService implements SysCacheSettingRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "setting";
    }

    @CloudtCacheMethod(name = "获取设置列表")
    @Override
    public List<SysSettingVO> all() {
        return getService(SysSettingService.class).all();
    }

    @CloudtCacheMethod(name = "根据编码获取设置信息")
    @Override
    public SysSettingVO oneByNo(String no) {
        Assert.hasText(no, "编码为空");
        return getService(SysSettingService.class).oneByNo(no);
    }
}
